<h2>
  RoboPLC
  <a href="https://crates.io/crates/roboplc"><img alt="crates.io page" src="https://img.shields.io/crates/v/roboplc.svg"></img></a>
  <a href="https://docs.rs/roboplc"><img alt="docs.rs page" src="https://docs.rs/roboplc/badge.svg"></img></a>
</h2>

<img src="https://raw.githubusercontent.com/roboplc/roboplc/main/roboplcline_.png"
width="200" />

[RoboPLC](https://www.bohemia-automation.com/software/roboplc/) 是一套完整的框架和工具集，用于使用Rust语言创建实时微服务、PLC和工业级机器人。

该crate设计为既可以单独使用其所有组件，也可以一起使用。

RoboPLC是[EVA ICS](https://www.eva-ics.com/)工业自动化平台的一部分。

实时安全的数据同步组件从[RTSC](https://docs.rs/rtsc)crate中重新导出，RTSC是RoboPLC项目的一部分，可以直接使用，无需使用RoboPLC。

RoboPLC生态系统提供：

* [roboplc-cli (robo)](https://info.bma.ai/en/actual/roboplc/flashing.html) - 用于创建和管理RoboPLC项目的CLI工具

* [RoboPLC manager](https://info.bma.ai/en/actual/roboplc/config.html) - 用于监控和管理基于RoboPLC的系统的Web界面和HTTP API

<img src="https://info.bma.ai/en/actual/_images/manager-program.png" width="550" />

## 技术文档

可在 <https://info.bma.ai/en/actual/roboplc/index.html> 获取

## 示例

可在 <https://github.com/roboplc/roboplc/tree/main/examples> 找到

## DataBuffer

[`buf::DataBuffer`] 涵盖了一种典型的数据交换模式，即从单个或多个生产者收集（缓存）数据帧，然后由单个消费者批量获取并提交，例如提交到本地数据库或外部总线。

<img
src="https://raw.githubusercontent.com/roboplc/roboplc/main/schemas/databuffer.png"
width="350" />

* 始终具有固定容量

* 开箱即用的线程安全

* 可以强制推送帧，覆盖之前的帧，类似环形缓冲区。

## Hub

[`hub::Hub`] 实现了数据中心（进程内发布/订阅）模型，多个客户端（通常是线程工作者）通过单个虚拟总线交换数据，而不是使用直接通道。

这给数据交换带来了一些额外的开销，但使架构明显更清晰，降低了代码维护成本并带来了额外的功能。

<img
src="https://raw.githubusercontent.com/roboplc/roboplc/main/schemas/hub.png"
width="550" />

* 经典的发布/订阅模式，没有数据序列化开销

* 基于 [`policy_channel`]，允许混合不同类型的数据并在需要时应用额外的策略

* 完全被动模型，没有"服务器"线程。

## pdeque 和 policy_channel

基于策略的双端队列 [`rtsc::pdeque::Deque`] 是构建基于策略的通道的组件。

[`policy_channel`] 是基于策略双端队列的通道模块。

支持的数据策略：

* **Always** 帧总是被传递
* **Latest** 帧总是被传递，如果没有空间则丢弃之前的帧（类似环形缓冲区）
* **Optional** 如果没有空间，帧可以被跳过
* **Single** 帧必须只传递一次（最新的一个）
* **SingleOptional** 帧必须只传递一次（最新的一个）且是可选的

此外，组件支持按数据优先级排序，如果数据类型实现了过期标记方法，则自动丢弃过期数据。

[`policy_channel`] 是一个实时安全的通道，这意味着它可能不如流行的通道实现那么快（甚至可能比 [`std::sync::mpsc`] 提供的通道更慢）。但它对实时应用程序**完全安全**，意味着没有自旋循环，数据总是以最小延迟传递，线程不会相互阻塞。

## 实时

[`thread_rt::Builder`] 提供了一个线程构建器组件，它扩展了标准线程构建器，具有实时功能：调度策略和CPU亲和性（仅限Linux）。

[`supervisor::Supervisor`] 提供了一个轻量级任务监督器来管理已启动的线程。

## Controller

[`controller::Controller`] 是将所有功能混合在一起的主要组件。

<img
src="https://raw.githubusercontent.com/roboplc/roboplc/main/schemas/controller.png"
width="550" />

## I/O

[`io`] 模块提供了一套工具，用于与现场设备和SCADA总线一起工作。

目前支持：

* 通过 [`io::modbus`] 的Modbus（RTU/TCP）（[Modbus客户端/主站示例](https://github.com/roboplc/roboplc/blob/main/examples/modbus-master.rs)，[Modbus服务器/从站示例](https://github.com/roboplc/roboplc/blob/main/examples/modbus-slave.rs)），需要 `modbus` crate特性。

* 通过 [`io::raw_udp`] 的原始UDP输入/输出（[原始UDP输入/输出示例](https://github.com/roboplc/roboplc/blob/main/examples/raw-udp.rs)）

* 通过 [`io::pipe`] 的子进程管道（[子进程管道示例](https://github.com/roboplc/roboplc/blob/main/examples/pipe.rs)）

* 通过 [`io::eapi`] 的[EVA ICS](https://www.eva-ics.com/) EAPI输入/输出（[EVA ICS示例](https://github.com/roboplc/roboplc/blob/main/examples/eapi.rs)），需要 `eapi` crate特性

* 通过 [`snmp2`](https://crates.io/crates/snmp2) 外部crate的SNMP v1/2/3。

* [ADS](https://crates.io/crates/roboplc-io-ads) 连接器，用于[Beckhoff TwinCAT](https://infosys.beckhoff.com/english.php?content=../content/1033/tcinfosys3/11291871243.html&id=)，商业使用需要许可证

* [IEC 60870-5](https://crates.io/crates/roboplc-io-iec60870-5) 客户端，商业使用需要许可证

## 相关crate

RoboPLC项目提供了额外的crate，可以与RoboPLC一起使用，也可以单独使用：

* [RTSC](https://crates.io/crates/rtsc) - 实时同步组件，一套实时安全的数据同步组件，RoboPLC的核心组件

* [atomic-timer](https://crates.io/crates/atomic-timer) - 用于典型自动化任务的原子计时器组件

* [rpdo](https://crates.io/crates/rpdo) - RoboPLC数据对象协议，用于进程和设备之间的数据同步

* [ehmi](https://crates.io/crates/ehmi) - 用于`egui`界面的HMI组件。

* [metrics-exporter-scope](https://crates.io/crates/metrics-exporter-scope) - 用于[metrics](https://crates.io/crates/metrics)生态系统的示波器式导出器

* [heartbeat-watchdog](https://crates.io/crates/heartbeat-watchdog) - 用于关键任务系统监控的心跳和看门狗组件

* [rvideo](https://crates.io/crates/rvideo) - 视频流调试

* [rflow](https://crates.io/crates/rflow) - 允许快速为无头程序创建类聊天的诊断界面

## 锁定安全

注意：异步组件仅使用`parking_lot_rt`锁定。

默认情况下，该crate使用[parking_lot](https://crates.io/crates/parking_lot)进行锁定。对于实时应用程序，可以使用以下特性：

* `locking-rt` - 使用[parking_lot_rt](https://crates.io/crates/parking_lot_rt) crate，这是parking_lot的无自旋分支。

* `locking-rt-safe` - 使用[RTSC](https://crates.io/crates/rtsc)优先级继承锁定，不受优先级反转影响（仅限Linux，推荐内核5.14+）。

注意：要切换锁定策略，请禁用crate的默认特性。

在使用CLI创建新项目时也可以选择锁定策略：

```shell
robo new --locking rt-safe # CLI创建的项目默认为rt-safe
```

## 在其他平台上使用

组件 [`thread_rt`]、[`supervisor`] 和 [`controller`] 只能在Linux机器上工作。

尽管如此，"cargo check"应该可以在Windows和OSX上工作，以便开发人员在这些平台上编写基于RoboPLC的程序。如果任何crate特性失败，请报告问题。

## 从0.5.x迁移

* 如果使用 `io::eapi`，动作处理程序现在必须返回可序列化的值。

* 为了正确支持 `hmi`，确保在 `roboplc.program` 服务（`/lib/systemd/system/roboplc.program.service`）中配置了 `RuntimeDirectory`：

```ini
[Service]
# ...
RuntimeDirectory=roboplc
RuntimeDirectoryMode=700
```

## 从0.4.x迁移

* 某些 `thread-rt` 模块组件已移至 [`rtsc`](https://crates.io/crates/rtsc) crate。RoboPLC重新导出它们，增加了与模拟模式的兼容性。

* `thread_rt::set_simulated` 已移至 [`set_simulated`]。

* `thread_rt` 组件 `CpuGovernor` 和 `SystemConfig` 已移至 [`system`] crate模块。

* `openssl-vendored` 特性已被移除，因为[EVA ICS](https://www.eva-ics.com/) EAPI现在只有某些特定功能才需要 `openssl` 作为可选依赖项。

## 从0.3.x迁移

* `pchannel` 和 `pchannel_async` 已分别重命名为 [`policy_channel`] 和 [`policy_channel_async`]。

* 默认情况下，该crate使用[parking_lot](https://crates.io/crates/parking_lot)进行锁定。要切换到更安全的实时锁定，请禁用crate的默认特性，并启用 `locking-rt` 或 `locking-rt-safe`。**这对实时应用程序很重要，必须手动启用**。

* 由于[RTSC](https://crates.io/crates/rtsc)组件与锁无关，这需要指定通用锁定类型，模块 [`channel`]、[`policy_channel`]、[`buf`] 和 [`semaphore`] 现在是RTSC模块的包装器，具有所选的锁定策略。

* [`hub_async`] 现在需要启用 `async` 特性。

## MSRV

RoboPLC支持的最低主流Rust版本与[Ferrocene](https://ferrocene.dev/) Rust编译器同步。这允许创建符合ISO 26262（TCL 3/ASIL D）、IEC 61508（T3）和IEC 62304的关键任务软件。

当前MSRV：主流1.81.0，Ferrocene 24.11.0。某些功能可能适用于较旧的Rust版本。