# Open Webui

用户友好的 AI 界面

![Open Webui](https://file.lifebus.top/imgs/open-webui_cover.png)

![](https://img.shields.io/badge/%E6%96%B0%E7%96%86%E8%90%8C%E6%A3%AE%E8%BD%AF%E4%BB%B6%E5%BC%80%E5%8F%91%E5%B7%A5%E4%BD%9C%E5%AE%A4-%E6%8F%90%E4%BE%9B%E6%8A%80%E6%9C%AF%E6%94%AF%E6%8C%81-blue)

## 简介

Open WebUI 是一个可扩展的、功能丰富且用户友好的自托管 AI 平台，旨在完全离线运行。它支持各种 LLM 运行器，如 Ollama 和兼容
OpenAI 的 API，内置 RAG 推理引擎，使其成为强大的 AI 部署解决方案。

## 特性

🚀 轻松设置：使用 Docker 或 Kubernetes（kubectl、kustomize 或 helm）无缝安装，以获得无烦恼的体验，支持带有:ollama和:cuda标签的镜像。

🤝 奥拉马/开放 AI API 集成：轻松集成与奥拉马模型兼容的 API，实现多功能的对话。自定义开放 AI API URL，以连接到
LMStudio、GroqCloud、Mistral、OpenRouter 等。

🛡️ 细粒度权限和用户组：通过允许管理员创建详细的用户角色和权限，我们确保了一个安全用户环境。这种细粒度不仅增强了安全性，还允许定制用户体验，培养用户之间的所有权和责任感。

手机 响应式设计：在桌面电脑、笔记本电脑和移动设备上享受无缝体验。

手机 渐进式 Web 应用（PWA）：使用我们的 PWA，在您的移动设备上享受原生应用般的体验，提供本地主机上的离线访问和无缝的用户界面。

✒️🔢 全 Markdown 和 LaTeX 支持：通过全面的 Markdown 和 LaTeX 功能提升您的 LLM 体验，丰富您的交互。

🎤📹 免提语音/视频通话：体验集成免提语音和视频通话功能的无缝通信，让您享受更加生动和互动的聊天环境。

🛠️ 模型构建器：通过 Web 界面轻松创建 Ollama 模型。创建和添加自定义角色/代理，自定义聊天元素，并通过开放 WebUI 社区集成轻松导入模型。

🐍 原生 Python 函数调用工具：通过工具工作区内置代码编辑器支持，增强您的 LLMs。通过简单添加您的纯 Python 函数，实现与 LLMs
的无缝集成。

📚 本地 RAG 集成：深入了解聊天交互的未来，利用突破性的检索增强生成（RAG）支持。此功能无缝将文档交互集成到您的聊天体验中。
您可以直接将文档加载到聊天中，或将文件添加到您的文档库中，使用查询前的#命令轻松访问它们。

🔍 Web Search for RAG：使用 SearXNG、Google PSE、Brave Search、serpstack、serper、Serply、DuckDuckGo、TavilySearch、SearchApi 和
Bing 等提供商进行网络搜索，并将结果直接注入到您的聊天体验中。

🌐 网页浏览功能：使用#命令后跟 URL，无缝将网站集成到您的聊天体验中。此功能允许您直接将网络内容融入对话中，增强您互动的丰富性和深度。

🎨 图像生成集成：无缝集成图像生成功能，使用 AUTOMATIC1111 API 或 ComfyUI（本地）以及 OpenAI 的
DALL-E（外部）等选项，通过动态视觉内容丰富您的聊天体验。

⚙️ 多种模型对话：轻松同时与各种模型互动，利用它们的独特优势以获得最佳响应。通过并行利用多样化的模型集来提升您的体验。

基于角色的访问控制（RBAC）：通过受限权限确保安全访问；只有授权人员可以访问您的 Ollama，且模型创建/提取的专属权限仅限于管理员。

🌐🌍 多语言支持：使用我们的国际化（i18n）支持，用您喜欢的语言体验 Open WebUI。加入我们，扩展我们的支持语言！我们正在积极寻找贡献者！

🧩 管道，开放 WebUI 插件支持：通过管道插件框架无缝将自定义逻辑和 Python 库集成到 Open WebUI 中。启动您的管道实例，将 OpenAI
URL 设置为管道 URL，探索无限可能。示例包括函数调用、用户速率限制以控制访问、使用 Langfuse 等工具进行使用监控、与
LibreTranslate 的实时翻译以支持多语言、有毒信息过滤等更多功能。

🌟 持续更新：我们致力于通过定期更新、修复和新功能来改进 Open WebUI。

---

![Ms Studio](https://file.lifebus.top/imgs/ms_blank_001.png)
