# Artalk

一个自托管的评论系统

![Artalk](https://file.lifebus.top/imgs/artalk_cover.png)

Artalk 是一款简单易用但功能丰富的评论系统，你可以开箱即用地部署并置入任何博客、网站、Web 应用。

![](https://img.shields.io/badge/%E6%96%B0%E7%96%86%E8%90%8C%E6%A3%AE%E8%BD%AF%E4%BB%B6%E5%BC%80%E5%8F%91%E5%B7%A5%E4%BD%9C%E5%AE%A4-%E6%8F%90%E4%BE%9B%E6%8A%80%E6%9C%AF%E6%94%AF%E6%8C%81-blue)

## 亮点

🍃 前端 ~40KB，纯天然 Vanilla JS

🍱 后端 Golang，高效轻量跨平台

🐳 通过 Docker 一键部署，方便快捷

🌈 开源程序，自托管，隐私至上

## 特性

| 特性  | 描述                       |
|:---:|:-------------------------|
| 📚  | 侧边栏: 快速管理、直观浏览           |
| 🔐  | 社交登录: 通过社交账号快速登录         |
| 💌  | 邮件通知: 多种发送方式、邮件模板        |
| 📢  | 多元推送: 多种推送方式、通知模版        |
| 🔔  | 站内通知: 红点标记、提及列表          |
| 🔒  | 验证码: 多种验证类型、频率限制         |
| 🚫  | 评论审核: 内容检测、垃圾拦截          |
| 📸  | 图片上传: 自定义上传、支持图床         |
| 📝  | Markdown: 支持 Markdown 语法 |
| 😄  | 表情包: 兼容 OwO，快速集成         |
| 🌐  | 多站点: 站点隔离、集中管理           |
| 👤  | 管理员: 密码验证、徽章标识           |
| 📑  | 页面管理: 快速查看、标题一键跳转        |
| 📊  | 浏览量统计: 轻松统计网页浏览量         |
| 📖  | 层级结构: 嵌套分页列表、滚动加载        |
| 🔼  | 评论投票: 赞同或反对评论            |
| 🔄  | 评论排序: 多种排序方式，自由选择        |
| 🔍  | 评论搜索: 快速搜索评论内容           |
| 🔝  | 评论置顶: 重要消息置顶显示           |
| 👀  | 仅看作者: 仅显示作者的评论           |
| 🔗  | 评论跳转: 快速跳转到引用的评论         |
| 💾  | 自动保存: 输入内容防丢功能           |
| 🌍  | IP 属地: 用户 IP 属地展示        |
| 📦  | 数据迁移: 自由迁移、快速备份          |
| 🖼️ | 图片灯箱: 图片灯箱快速集成           |
| 📱  | 图片懒加载: 延迟加载图片，优化体验       |
| 📐  | Latex: Latex 公式解析集成      |
| 🌙  | 夜间模式: 夜间模式切换             |
| 🔧  | 扩展插件: 创造更多可能性            |
| 🌐  | 多语言: 多国语言切换              |
| 💻  | 命令行: 命令行操作管理能力           |
| 📜  | API 文档: 提供 OpenAPI 格式文档  |
| 🚀  | 程序升级: 版本检测，一键升级          |

## 安装说明

### `应用密钥` 配置

数据加密密钥，非管理员密码。

### `管理员密码` 配置

管理员密码，用于登录后台管理。

基本格式：`(加密方式)加密后的密码`

示例密码：`123456`

#### 加密方式：`md5`

填写案例：`(md5)e10adc3949ba59abbe56e057f20f883e`

#### 加密方式：`bcrypt`

填写案例：`(bcrypt)$2a$10$yS/EhHU1xqjNpboe8DWkb.AvWdBb5/.Ny3reXy8SltlVaquiSGwzu`

### `受信任的域名 (多个域名用空格分隔)` 配置

填写允许访问的域名，多个域名用空格分隔。

如果您需要将插件使用在以下博客地址：

+ `https://blog1.com`

+ `https://blog2.com`

填写案例：`https://blog1.com https://blog2.com`

---

![Ms Studio](https://file.lifebus.top/imgs/ms_blank_001.png)
