# BookStack

一个用于存储和组织信息及文档的平台

![BookStack](https://file.lifebus.top/imgs/bookstack_cover.png)

![](https://img.shields.io/badge/%E6%96%B0%E7%96%86%E8%90%8C%E6%A3%AE%E8%BD%AF%E4%BB%B6%E5%BC%80%E5%8F%91%E5%B7%A5%E4%BD%9C%E5%AE%A4-%E6%8F%90%E4%BE%9B%E6%8A%80%E6%9C%AF%E6%94%AF%E6%8C%81-blue)

## 简介

BookStack 是一个具有偏见的文档平台，它提供了一种愉快且简单的开箱即用体验。
新用户在使用实例时应该觉得体验直观，并且只需要基本的文字处理技能就能参与在 BookStack 上创建内容。
平台应向需要的高级电源功能提供支持，但不应干扰核心简单用户体验。

BookStack 不是设计为可扩展的平台，用于上述声明之外的目的。

## 特性

🚀 免费与开源

BookStack 完全免费且开源，采用 MIT 许可。源代码可在 GitHub 上获取。下载和安装自己的 BookStack 实例无需付费。

🚀 简单，简洁的界面

简洁性一直是构建 BookStack 时的首要任务。页面编辑器拥有简单的所见即所得（WYSIWYG）界面，所有内容都被划分为三个简单的现实世界组：

🚀 可搜索和互联

BookStack 中的内容可完全搜索。您可以在书籍级别或跨所有书籍、章节和页面进行搜索。直接链接到任何段落的能力使您能够保持文档的关联性。

🚀 可配置

配置选项允许您设置 BookStack 以适应您的使用情况。您可以更改名称、标志和注册选项。您还可以更改整个系统是否公开可见。

🚀 简单要求

BookStack 使用 PHP 构建，基于 Laravel 框架，并使用 MySQL 存储数据。性能得到了考虑，BookStack 可以在 5 美元的 Digital Ocean
VPS 上愉快地运行。

🚀 内置 diagrams.net

页面编辑器中的 BookStack 包含diagrams.net 内置绘图功能，允许您在文档中快速轻松地创建图表。

🚀 多语言

BookStack 用户可以设置他们喜欢的语言。多亏了伟大的社区贡献者，当前内置的 BookStack 语言包括 EN、FR、DE、ES、IT、JA、NL、PL、RU
以及许多更多。

🚀 可选 Markdown 编辑器

如果您喜欢使用 Markdown 编写，BookStack 支持您。提供了一个 Markdown 编辑器，并支持您在编写文档时实时预览。

🚀 集成认证

以及默认的电子邮件/密码登录社交提供者，如 GitHub、Google、Slack、AzureAD 等均可使用。企业环境提供 Okta、SAML2 和 LDAP 选项。

🚀 强大功能

在强大的搜索和链接功能之上，还有跨书排序、页面修订和图像管理。完整的角色和权限系统允许您根据需要锁定内容和操作。

🚀 多因素认证

MFA 内置且可在需要时按角色级别强制执行。 MFA 选项包括 TOTP（谷歌/微软身份验证器、Authy 等）和静态备份码。

🚀 暗黑模式与明亮模式

BookStack 提供浅色主题和深色主题的用户界面，节省眼睛 那些更喜欢在阴影中工作的人。这可以在用户级别进行配置。

## 安装说明

> 默认管理员账号：`admin@admin.com`
>
> 默认管理员密码：`password`
>
> 默认已开启队列模式

### 服务地址

如果部署后需要修改：

```bash
docker exec -it <bookstack> php /app/www/artisan bookstack:update-url ${OLD_URL} ${NEW_URL}
```

+ `${OLD_URL}`：原服务地址
+ `${NEW_URL}`：新服务地址
+ `<bookstack>`：容器名称

### 应用密钥

> 必须是 32 个字符的随机字符串，并使用 Base64编码，用于加密会话数据。
>
> 如果提供错误的密钥，将导致无法正常使用应用程序。
>
> 示例值：`base64:W/NpvTrf6PjZDS7Np+sjOYGQwUg3OoxrbXPVtwWYryw=`

```sh
docker run -it --rm --entrypoint /bin/bash lscr.io/linuxserver/bookstack:latest appkey
```

## 高级配置

如果您想使用 BookStack 的额外功能，如电子邮件、LDAP 等，您需要设置额外的环境变量或根据 BookStack 文档的指导创建自己的.env
文件。

您可修改配置文件： `<持久化目录>/config/www/.env`，然后重启容器。

---

![Ms Studio](https://file.lifebus.top/imgs/ms_blank_001.png)
