# Gost

用于现代出版、会员制、订阅和通讯的独立技术

![Gost](https://file.lifebus.top/imgs/gost_cover.png)

Ghost 是一个基于现代 Node.js 技术堆栈构建的开源专业发布平台，专为需要强大功能、灵活性和性能的团队而设计。

![](https://img.shields.io/badge/%E6%96%B0%E7%96%86%E8%90%8C%E6%A3%AE%E8%BD%AF%E4%BB%B6%E5%BC%80%E5%8F%91%E5%B7%A5%E4%BD%9C%E5%AE%A4-%E6%8F%90%E4%BE%9B%E6%8A%80%E6%9C%AF%E6%94%AF%E6%8C%81-blue)

## 特性

+ 独立结构

Ghost 的结构是一个非营利组织，以确保它永远不会合法地被出售，并且将始终保持独立，根据用户的需求构建产品，而不是寻求💰回报的投资者的突发奇想。

+ 可持续发展的业务

虽然我们发布的软件是免费的，但我们还为其销售高级托管托管，这为非营利组织提供了可持续的商业模式，并使其能够 100% 自筹资金。

+ 分布式团队

拥有可持续的业务使我们能够聘请开源贡献者全职从事 Ghost 工作，而且我们完全远程完成这项工作。 Ghost 核心团队完全分布在他们选择的任何地方。

+ 默认透明

我们透明地分享我们的收入并公开我们的代码，以便任何人都可以验证我们所做的事情以及我们如何做。没有斗篷或匕首。

+ 无条件开源

我们所有的项目都是在宽松的开源MIT 许可证下发布的，因此即使公司失败，我们的代码仍然可以被世界上任何人不受限制地使用和继承。

🚀 内置会员资格和订阅

Ghost 不仅可以为匿名访问者创建内容，还可以让您将受众转变为企业，并为会员注册和付费订阅商务提供原生支持。它是唯一一个默认内置会员资格并深度集成的平台。

🚀 开发者友好的API

Ghost 的核心是一个自消耗的 RESTful JSON API，具有解耦的管理客户端和前端。我们提供了很多工具来让网站尽快运行，但最终它只是
JSON ™️，所以如果您想完全无头使用 Ghost 并编写自己的前端或后端……您可以！

🚀 丰富编辑器

Ghost 拥有每个作家都想要的丰富编辑器，但在幕后它提供的功能远远超出您的预期。
所有内容都以基于 JSON 的标准化文档存储格式（称为 Lexical）存储，其中包括对称为 Cards 的可扩展富媒体对象的支持。

简单来说，您可以将其视为在 Medium 编辑器中集成 Slack，存储合理且可通过 API 完全访问。

🚀 自定义网站结构

Ghost 中的路由完全可以根据您的需要进行配置。开箱即用的 Ghost 附带了标准的反向时间顺序帖子源，带有干净的永久链接和基本页面，但这很容易更改。

无论您需要一个带有/en/和/de/基本 URL 的完整多语言站点，还是想要为/europe/uk/london/等分层数据构建特定的目录结构 — Ghost
的路由层可以任意数量进行操作实现您的用例的方法。

🚀 角色和权限

从一开始就使用内置的合理用户角色和权限来设置您的站点。

+ 贡献者：可以登录并撰写帖子，但不能发布。
+ 作者：可以创建和发布新的帖子和标签。
+ 编辑：可以邀请、管理和编辑作者和贡献者。
+ 管理员：拥有编辑所有数据和设置的完全权限。
+ 所有者：无法删除的管理员+有权访问账单详细信息。

🚀 自定义主题

Ghost 附带了一个简单的 Handlebars.js
前端主题层，该层使用起来非常简单，而且功能强大得令人惊讶。许多人坚持使用默认主题（现场演示/源代码），它提供了干净的杂志设计 -
但这可以修改或完全替换。

🚀 应用程序和集成

因为 Ghost 是完全开源的，构建为 JSON API，具有 Webhooks，并且让您可以完全控制前端：它本质上与所有东西集成。有些事情比其他事情更容易，但几乎任何事情都可以通过一点努力来实现。
或者是一个比 1803 年更近的比喻。

🚀 搜索引擎优化

Ghost 配备了世界一流的 SEO 以及确保您的内容快速一致地显示在搜索索引中所需的一切。

+ 无需插件

Ghost 将所有基本技术 SEO 优化直接内置于核心中，无需依赖第三方插件。得益于 Node.js，它还具有远远优越的速度和页面加载性能。

+ 自动谷歌 XML 站点地图

Ghost 将自动生成并链接到完整的 Google 站点地图，包括您网站上的每个页面，以确保搜索引擎能够为每个 URL 建立索引。

+ 自动结构化数据+JSON-LD

Ghost 生成有关页面的基于JSON-LD 的结构化元数据，这样您就不必依赖标记中混乱的微格式来提供语义上下文。即使您更改主题或前端，您的
SEO 仍然完好无损。
Ghost 还为 Facebook OpenGraph 和 Twitter Card 添加了自动代码。

+ 规范标签

Ghost 会自动为每个帖子和页面生成正确的rel="canonical"标签，以便搜索引擎始终优先考虑一个真正的链接。

## 安装说明

> 后台管理地址：`http://127.0.0.1:2368/ghost`
>
> 首次进入后台管理，会提示创建管理员账号，然后登录即可。

## 使用说明

### 语言设置

没有更好的解决办法,即使设置 `zh` 也不会生效。

### 邮件配置

Ghost 默认使用 Mailgun 作为邮件服务，但是由于其已经移除 `免费套餐`, 我们将配置 `smtp` 作为邮件服务商。

如果存在发信失败，请查看日志，可能是邮件服务商的问题。

如果发信人与配置不一致，识别到 `域名` 作为发信人，即使配置了发信人， 也会被忽略。

可以通过 `设置` >> `门户设置` >> `账户设置` 修改 `Support email address` 为配置的发信人。

## 反向代理

> Nginx

```nginx
location / {
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto $scheme;
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header Host $http_host;
    proxy_pass http://127.0.0.1:2368;
}

client_max_body_size 50m;
```

---

![Ms Studio](https://file.lifebus.top/imgs/ms_blank_001.png)
