# WuKongIM 悟空IM

高性能通用分布式通讯服务，支持聊天应用，消息推送，物联网通讯，音视频信令，直播弹幕，客服系统，AI 通讯，即时社区等场景。

![WuKongIM](https://file.lifebus.top/imgs/wukongim_cover.png)

![](https://img.shields.io/badge/%E6%96%B0%E7%96%86%E8%90%8C%E6%A3%AE%E8%BD%AF%E4%BB%B6%E5%BC%80%E5%8F%91%E5%B7%A5%E4%BD%9C%E5%AE%A4-%E6%8F%90%E4%BE%9B%E6%8A%80%E6%9C%AF%E6%94%AF%E6%8C%81-blue)

## 特性

🎦独特性

群成员无上限，轻松支持10万人群聊，消息可永久存储。

📚资源消耗低

自研二进制协议，心跳包只有1字节，省流量，省电量，传输更迅速。

🔐安全性

消息通道和消息内容全程加密，防中间人攻击和窜改消息内容，服务端数据实时备份，数据不丢失。

🚀 性能

基于pebble kv数据库，研发了针对于IM这种服务的特有分布式数据库，省了其他数据库为了通用性而带来的性能损耗， 因为存储快，所以消息快。

🔥高可用

通过魔改raft分布式协议，实现了自动容灾，一台机器宕机，另一台机器自动接管，对外无感知。

去中心化，无单点，无中心节点，每个节点都是独立且平等的，都可以提供服务。

扩容方便，只需增加机器，不需要停机，不需要迁移数据，自动按策略分配数据。

🕹️ 易用性

不依赖任何第三方中间件，部署简单，一条命令即可启动。

采用频道订阅发布的设计理念，容易理解，容易上手。

与Redis一样简单，Kafka一样高性能，MySQL一样可靠

🌲技术支持

官方团队提供技术支持，提供技术文档，提供技术交流群，提供issue反馈。

## 适用场景

### 即时通讯

+ 群频道支持
+ 个人频道支持
+ 消息永久存储
+ 离线消息推送支持
+ 最近会话维护

### 消息推送/站内消息

+ 群频道支持
+ 个人频道支持
+ 离线消息推送支持

### 客服系统

+ 客服频道支持

+ 消息支持投递给第三方服务器

+ 第三方服务器可决定分配指定的订阅者成组投递

(整体逻辑： 创建频道 -> 发送消息 -> 匹配客服 -> 客服加入频道 -> 开始聊天 )

### 游戏聊天室

+ 大群频道支持

### 音视频信令服务器

+ 支持临时指令消息投递

### 直播弹幕

+ 临时消息投递

+ 临时订阅者支持

一个直播一个频道，用户进入直播就是用户订阅频道，用户退出直播就是用户取消订阅频道，直播结束就是频道销毁。

### 实时 AI 反馈

+ 支持客户端发的消息推送给第三方服务器，第三方服务器反馈给 AI 后返回的结果再推送给客户端

### 即时社区

+ 社区频道支持
+ 支持 topic 模式的消息投递

### 物联网通讯

+ mqtt 协议支持（待开发）
+ 支持发布与订阅

## 安装说明

> 监控地址 http://127.0.0.1:5300/web
>
> 具体参考日志：【MonitorServer】Monitor web address：xxx
>
> 演示地址 http://127.0.0.1:5172/chatdemo
>
> 具体参考日志：【DemoServer】Chat demo address：xxx

---

![Ms Studio](https://file.lifebus.top/imgs/ms_blank_001.png)
